<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title><?php echo $name; ?> - Reset Password</title>
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/usertemplate/assets/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <style>
        body {
            background: #f5f5f5;
        }
        .form-box {
            margin: 100px auto;
            width: 400px;
            padding: 30px;
            background: #fff;
            border-radius: 10px;
            box-shadow: 0px 0px 15px rgba(0, 0, 0, 0.1);
        }
    </style>
</head>
<body>
<div class="form-box">
    <h3 class="text-center">Reset Password</h3>
    <form action="<?php echo site_url('course/resetpassword/' . $role . '/' . $verification_code); ?>" method="post">
        <?php echo $this->customlib->getCSRF(); ?>
        <div class="form-group">
            <label for="password">New Password</label>
            <input type="password" name="password" id="password" class="form-control" required>
            <span class="text-danger"><?php echo form_error('password'); ?></span>
        </div>
        <div class="form-group">
            <label for="confirm_password">Confirm Password</label>
            <input type="password" name="confirm_password" id="confirm_password" class="form-control" required>
            <span class="text-danger"><?php echo form_error('confirm_password'); ?></span>
        </div>
        <button type="submit" class="btn btn-primary btn-block">Reset Password</button>
    </form>
    <div class="text-center mt-3">
        <a href="<?php echo site_url('course') ?>" class="forgot"><i class="fa fa-key"></i> Back to Login</a>
    </div>
</div>

<!-- Javascript -->
<script src="<?php echo base_url(); ?>backend/usertemplate/assets/js/jquery-1.11.1.min.js"></script>
<script src="<?php echo base_url(); ?>backend/usertemplate/assets/bootstrap/js/bootstrap.min.js"></script>
<script src="<?php echo base_url(); ?>backend/usertemplate/assets/js/jquery.backstretch.min.js"></script>
<script>
    // Apply background stretch effect
    $.backstretch("<?php echo base_url(); ?>backend/usertemplate/assets/img/backgrounds/1.jpg");
</script>
</body>
</html>
